//
//  GSLayer+AlignComponents.h
//  GlyphsCore
//
//  Created by Georg Seifert on 21.07.18.
//  Copyright © 2018 schriftgestaltung.de. All rights reserved.
//

#import <GlyphsCore/GSLayer.h>
/**
 Layer Align Components
 */
@interface GSLayer (AlignComponents)

/** Helper function to fix component position.

 Call this every time you need to access the component.
 If the first component is a letter and the second is a accent, the Letter is placed at the origin, the width of the glyphs is copied from the referenced Glyph. If it find corresponding anchors it aligns the accents on it.
 */
#ifndef LIBCORE
- (void)alignComponents;
- (void)alignComponents:(BOOL)wait;
- (BOOL)doAlignComponents;
- (BOOL)needsAlignment;
- (BOOL)checkIfAlign;

- (void)metricKeyOffsetLeft:(out CGFloat *)leftOffset right:(out CGFloat *)rightOffset;
#endif

@end
